// TestDlg.cpp : implementation file
//

#include "stdafx.h"
#include "NEDImage.h"
#include "TestDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTestDlg dialog

CTestDlg::CTestDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CTestDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CTestDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CTestDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTestDlg)
	DDX_Control(pDX, IDC_NEDIMAGECTRL1, m_ImageCtl);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CTestDlg, CDialog)
	//{{AFX_MSG_MAP(CTestDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_COMMAND(ID_FILE_OPEN, OnFileOpen)
	ON_COMMAND(ID_FILE_PRINT, OnFilePrint)
	ON_COMMAND(ID_DEVICE_PRINTER, OnDevicePrinter)
	ON_COMMAND(ID_DEVICE_SCREEN, OnDeviceScreen)
	ON_COMMAND(ID_HELP_ABOUTNEDIMAGEOCX, OnHelpAboutnedimageocx)
	ON_COMMAND(ID_IMAGE_COLORREDUCTION_ERRORDIFFUSION, OnImageColorreductionErrordiffusion)
	ON_COMMAND(ID_IMAGE_COLORREDUCTION_MEDIANCUT, OnImageColorreductionMediancut)
	ON_COMMAND(ID_IMAGE_COLORREDUCTION_ORDERED, OnImageColorreductionOrdered)
	ON_COMMAND(ID_IMAGE_FITTYPE_BESTFIT, OnImageFittypeBestfit)
	ON_COMMAND(ID_IMAGE_FITTYPE_HORIZONTALFIT, OnImageFittypeHorizontalfit)
	ON_COMMAND(ID_IMAGE_FITTYPE_ONETOONE, OnImageFittypeOnetoone)
	ON_COMMAND(ID_IMAGE_FITTYPE_VERTICALFIT, OnImageFittypeVerticalfit)
	ON_COMMAND(ID_IMAGE_IMAGEHEIGHT, OnImageImageheight)
	ON_COMMAND(ID_IMAGE_IMAGEWIDTH, OnImageImagewidth)
	ON_COMMAND(ID_IMAGE_NUMBEROFCOLORS, OnImageNumberofcolors)
	ON_COMMAND(ID_IMAGE_ROTATE_180, OnImageRotate180)
	ON_COMMAND(ID_IMAGE_ROTATE_270, OnImageRotate270)
	ON_COMMAND(ID_IMAGE_ROTATE_90, OnImageRotate90)
	ON_WM_SIZE()
	ON_COMMAND(ID_EDIT_COPY, OnEditCopy)
	ON_COMMAND(ID_SAVEAS, OnSaveas)
	ON_COMMAND(IDM_ADV_PRINT, OnAdvPrint)
	ON_COMMAND(IDM_PASTE_IMAGE, OnPasteImage)
	ON_COMMAND(ID_FILE_EXIT, OnOK)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTestDlg message handlers

BOOL CTestDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	CString strAboutMenu;
	strAboutMenu.LoadString(IDS_ABOUTBOX);
	if (!strAboutMenu.IsEmpty())
	{
		pSysMenu->AppendMenu(MF_SEPARATOR);
		pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
	}

	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CTestDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CTestDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

HCURSOR CTestDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CTestDlg::OnOK() 
{
	//Exit here!!!
	
	CDialog::OnOK();
}

void CTestDlg::OnFileOpen() 
{
CFileDialog dlg(TRUE, NULL, NULL, 
	OFN_FILEMUSTEXIST | OFN_LONGNAMES | OFN_PATHMUSTEXIST,
	"All Image Files|*.bmp;*.dib;*.jpg;*.pcx;*.pcd;*.tif;*.tga|"
	"Bitmap Files|*.bmp|"
	"DIB Files|*.dib|"
	"JPEG Files|*.jpg|"
	"PCX Files|*.pcx|"
	"PhotoCD Files|*.pcd|"
	"TIFF Files|*.tif|"
	"TGA Files|*.tga|"
	"All Files|*.*||",
	this);

	if (IDOK == dlg.DoModal())
	{
		CString csFile = dlg.GetPathName();

		//Load the file
		m_ImageCtl.SetPicture((LPCTSTR) csFile);

		if ((m_ImageCtl.GetNumImageColors() > 256) &&
			(m_ImageCtl.GetNumScreenColors() == 256))
		{
			//We need to do some color reduction on this image
			m_ImageCtl.MedianCutQuant();
		}

		//Refresh the file
		m_ImageCtl.Refresh();
	}
	
}

void CTestDlg::OnFilePrint() 
{
	m_ImageCtl.PrintImage();
}

void CTestDlg::OnDevicePrinter() 
{
	long lColors = m_ImageCtl.GetNumPrinterColors();
	CString cstemp;
	cstemp.Format("Number of colors default printer supports is %d.",lColors);
	AfxMessageBox(cstemp, MB_ICONINFORMATION);
}

void CTestDlg::OnDeviceScreen() 
{
	long lColors = m_ImageCtl.GetNumScreenColors();
	CString cstemp;
	cstemp.Format("Number of colors the screen displays is %d.",lColors);
	AfxMessageBox(cstemp, MB_ICONINFORMATION);
}

void CTestDlg::OnHelpAboutnedimageocx() 
{
	m_ImageCtl.AboutBox();
}

void CTestDlg::OnImageColorreductionErrordiffusion() 
{
	m_ImageCtl.ErrorDiffusionDither();
}

void CTestDlg::OnImageColorreductionMediancut() 
{
	m_ImageCtl.MedianCutQuant();
}

void CTestDlg::OnImageColorreductionOrdered() 
{
	m_ImageCtl.OrderedDither();
}

void CTestDlg::OnImageFittypeBestfit() 
{
	m_ImageCtl.SetFitType(BESTFIT);
}

void CTestDlg::OnImageFittypeHorizontalfit() 
{
	m_ImageCtl.SetFitType(HORZFIT);
}

void CTestDlg::OnImageFittypeOnetoone() 
{
	m_ImageCtl.SetFitType(ONETOONE);
}

void CTestDlg::OnImageFittypeVerticalfit() 
{
	m_ImageCtl.SetFitType(VERTFIT);
}

void CTestDlg::OnImageImageheight() 
{
	long lHeight = m_ImageCtl.GetImageHeight();
	CString cstemp;
	cstemp.Format("Original Image Height is %d.",lHeight);
	AfxMessageBox(cstemp, MB_ICONINFORMATION);
}

void CTestDlg::OnImageImagewidth() 
{
	long lWidth = m_ImageCtl.GetImageWidth();
	CString cstemp;
	cstemp.Format("Original Image Width is %d.",lWidth);
	AfxMessageBox(cstemp, MB_ICONINFORMATION);
}

void CTestDlg::OnImageNumberofcolors() 
{
	long lColors = m_ImageCtl.GetNumImageColors();
	CString cstemp;
	cstemp.Format("Original Number of Image Colors is %d.",lColors);
	AfxMessageBox(cstemp, MB_ICONINFORMATION);
}

void CTestDlg::OnImageRotate180() 
{
	m_ImageCtl.Rotate180();
}

void CTestDlg::OnImageRotate270() 
{
	m_ImageCtl.Rotate270();
}

void CTestDlg::OnImageRotate90() 
{
	m_ImageCtl.Rotate90();
}

void CTestDlg::OnSize(UINT nType, int cx, int cy) 
{
	CDialog::OnSize(nType, cx, cy);
	
	//Size the image ctl to the size of our window
	m_ImageCtl.MoveWindow(0,0,cx,cy);
}

void CTestDlg::OnEditCopy() 
{
	m_ImageCtl.CopyImageToClipboard();
}

void CTestDlg::OnSaveas() 
{
CFileDialog dlg(FALSE, NULL, NULL, 
	OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT| OFN_LONGNAMES,
	"All Image Files|*.bmp;*.dib;*.jpg;*.pcx;*.pcd;*.tif;*.tga|"
	"Bitmap Files|*.bmp|"
	"DIB Files|*.dib|"
	"JPEG Files|*.jpg|"
	"PCX Files|*.pcx|"
	"PhotoCD Files|*.pcd|"
	"TIFF Files|*.tif|"
	"TGA Files|*.tga|"
	"All Files|*.*||",
	this);

	if (IDOK == dlg.DoModal())
	{
		CWaitCursor cwc;
		CString csFile = dlg.GetPathName();

		//Get the extension
		CString csExt = csFile.Right(3);
		csExt.MakeUpper();

		if (csExt == "BMP" || csExt == "DIB")
		{
			m_ImageCtl.SaveAsBMP((LPCSTR) csFile);
		}
		else if (csExt == "PCX")
		{
			m_ImageCtl.SaveAsPCX((LPCSTR) csFile);
		}
		else if (csExt == "JPG")
		{
			//Default quality is 90, sohould prompt user for this
			m_ImageCtl.SaveAsJPEG((LPCSTR) csFile, 90);
		}
		else if (csExt == "TIF")
		{
			m_ImageCtl.SaveAsTIFF((LPCSTR) csFile);
		}
		else
		{
			m_ImageCtl.SaveAsTGA((LPCSTR) csFile);
		}
	}
}

void CTestDlg::OnAdvPrint() 
{
	//For this demo, we will print to the default
	//printer, without prompting the user or showing a cancel
	//dialog.  Many aditional advanced functions are available
	//for performing advanced prints.  Please consult the 
	//README.TXT file for further information
	m_ImageCtl.AdvPrintStartDoc(0, FALSE, FALSE);
	m_ImageCtl.AdvPrintStartPage();
	m_ImageCtl.AdvPrintImagePrint(0, 0, 300, 300);
	m_ImageCtl.AdvPrintImagePrint(500, 500, 800, 800);
	m_ImageCtl.AdvPrintEndPage();
	m_ImageCtl.AdvPrintEndDoc();
}

void CTestDlg::OnPasteImage() 
{
	//Load the file
	if (TRUE == m_ImageCtl.CreateImageFromClipboard())
	{
		if ((m_ImageCtl.GetNumImageColors() > 256) &&
			(m_ImageCtl.GetNumScreenColors() == 256))
		{
			//We need to do some color reduction on this image
			m_ImageCtl.MedianCutQuant();
		}

		//Refresh the file
		m_ImageCtl.Refresh();
	}
}
